% IAS-Letter Format 
% Thomas Uphill <uphill@ias.edu>
% $Id: snsletter.cls 195 2011-01-25 14:41:29Z uphill $
% $Rev: 195 $

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{snsletter}

% requirements
\RequirePackage{ifthen}
\RequirePackage{tikz}
\RequirePackage{color}

% Load Standard Letter Class
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{letter}}
\ProcessOptions
\LoadClass[letterpaper]{letter}

% variables
\newcommand{\telcode}{(609)}
\newcommand{\@email}{}
\newcommand{\email}[1]{\renewcommand{\@email}{#1}}
\email{}

\newcommand{\@jobtitle}{}
\newcommand{\jobtitle}[1]{\renewcommand{\@jobtitle}{#1}}
\jobtitle{}

\newcommand*{\fax}[1]{\def\faxnum{#1}}
\fax{}



\definecolor{grey}{gray}{0.4}

% fonts
\renewcommand{\encodingdefault}{T1}
\newfont{\bauerlarge}{bauerbodoni at 30pt}
\newfont{\bauerHuge}{bauerbodoni at 72pt}
\newfont{\bauernm}{bauerbodoni at 14pt}
\newfont{\bauerit}{bauerbodonii at 14pt}
\newfont{\bauerfoot}{bauerbodoni at 12pt}


% Define Letterhead

% Header
\newcommand{\iashead}
{\parbox[t]{\textwidth}{%
	\hspace*{-20pt}
	\begin{tikzpicture}
	\node[anchor=base west] (IAS) at (-1,0) {\bauerHuge \color{grey}{IAS}};
	\node[anchor=base west] (school) at (2.3,0.95) {\bauerlarge School of};
	\node[anchor=base west] (sns) at (2.3,0) {\bauerlarge Natural Sciences};
	\node[anchor=base west] (user) at (-1,-0.7) {\bauernm \color{grey}{\fromname \ \ {\bauerit \@jobtitle}}};
	\end{tikzpicture}
	}}%

% Footer
\newcommand{\iasfoot}{\parbox[t]{\textwidth}{%
	\centerline{\color{grey}{\bauerfoot 
\ifthenelse{\equal{\@email}{}}{}{ \@email\ $\bullet$ } 
phone \ifthenelse{\equal{\telephonenum}{}}{\telcode\ 734-8000}{\telcode\ \telephonenum}\ $\bullet$
fax \ifthenelse{\equal{\faxnum}{}}{\telcode\ 924-8399}{\telcode\ \faxnum}}}
	\centerline{\color{grey}{\bauerfoot Institute for Advanced Study $\bullet$ Einstein Drive, Princeton, New Jersey $\bullet$ \color{grey}{\bauerfoot www.sns.ias.edu}}}
	}}%

% Replace Standard Header & Footer
\providecommand{\@evenhead}{}\providecommand{\@oddhead}{}
\providecommand{\@evenfoot}{}\providecommand{\@oddfoot}{}
\pagestyle{headings}
\renewcommand{\ps@firstpage}
	{\setlength{\headheight}{41pt}
	 \setlength{\headsep}{25pt}
	 \renewcommand{\@oddhead}{\iashead}
	 \renewcommand{\@oddfoot}{\iasfoot}
	 \renewcommand{\@evenhead}{}
	 \renewcommand{\@evenfoot}{}}
