% IAS-Letter Format 
% Thomas Uphill <uphill@ias.edu>
% $Id: iasletter.cls 195 2011-01-25 14:41:29Z uphill $
% $Rev: 195 $

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{iasletter}

% requirements
\RequirePackage{ifthen}
\RequirePackage{tikz}
\RequirePackage{color}

% Load Standard Letter Class
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{letter}}
\ProcessOptions
\LoadClass[letterpaper]{letter}

% variables
\newcommand{\telcode}{(609)}
\newcommand{\@email}{}
\newcommand{\email}[1]{\renewcommand{\@email}{#1}}
\email{}

\newcommand{\@jobtitle}{}
\newcommand{\jobtitle}[1]{\renewcommand{\@jobtitle}{#1}}
\jobtitle{}

\newcommand*{\fax}[1]{\def\faxnum{#1}}
\fax{}



\definecolor{grey}{gray}{0.4}
\definecolor{lightgrey}{gray}{0.7}

% fonts
\renewcommand{\encodingdefault}{T1}
\newfont{\bauerias}{bauerbodoni at 16pt}
\newfont{\bauerlarge}{bauerbodoni at 30pt}
\newfont{\bauerHuge}{bauerbodoni at 72pt}
\newfont{\bauernm}{bauerbodoni at 14pt}
\newfont{\bauerit}{bauerbodonii at 14pt}
\newfont{\bauerfoot}{bauerbodoni at 12pt}


% Define Letterhead

% Header
\newcommand{\iashead}
{\parbox[t]{\textwidth}{%
	\hspace*{-20pt}
	\begin{tikzpicture}
	\node[anchor=base west] (IAS) at (-1,0) {\bauerHuge \color{lightgrey}{IAS}};
	\node[anchor=base west] (institute) at (0.2,0.65) {\bauerias Institute for Advanced Study};
	\node[anchor=base west] (user) at (-1,-0.5) {\bauernm \color{lightgrey}{\fromname \ \ \bauerit{\@jobtitle}}};
	\end{tikzpicture}
	}}%

% Footer
\newcommand{\iasfoot}{\parbox[t]{\textwidth}{%
	\centerline{\color{grey}{\bauerfoot 
\ifthenelse{\equal{\@email}{}}{}{ \@email\ $\bullet$ } 
phone \ifthenelse{\equal{\telephonenum}{}}{\telcode\ 734-8000}{\telcode\ \telephonenum}\ $\bullet$
fax \ifthenelse{\equal{\faxnum}{}}{\telcode\ 924-8399}{\telcode\ \faxnum}}}
	\centerline{\color{grey}{\bauerfoot Institute for Advanced Study $\bullet$ Einstein Drive, Princeton, New Jersey $\bullet$ www.ias.edu}}
	}}%

% Replace Standard Header & Footer
\providecommand{\@evenhead}{}\providecommand{\@oddhead}{}
\providecommand{\@evenfoot}{}\providecommand{\@oddfoot}{}
\pagestyle{headings}
\renewcommand{\ps@firstpage}
	{\setlength{\headheight}{41pt}
	 \setlength{\headsep}{25pt}
	 \renewcommand{\@oddhead}{\iashead}
	 \renewcommand{\@oddfoot}{\iasfoot}
	 \renewcommand{\@evenhead}{}
	 \renewcommand{\@evenfoot}{}}
